/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.movingelevators.gui.preview;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.movingelevators.gui.preview.WorldBlockCapture;
import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ElevatorPreviewRenderer {
    public static void renderPreview(WorldBlockCapture capture, AABB cabinBox, AABB previewBox, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        AABB bounds = capture.getBounds();
        Vec3 center = bounds.m_82399_();
        double span = Math.sqrt(bounds.m_82362_() * bounds.m_82362_() + bounds.m_82376_() * bounds.m_82376_() + bounds.m_82385_() * bounds.m_82385_());
        scale /= span;
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_85841_(1.0f, -1.0f, 1.0f);
        RenderSystem.m_157182_();
        PoseStack matrixStack = new PoseStack();
        matrixStack.m_85837_(x, -y, 350.0);
        matrixStack.m_85841_((float)scale, (float)scale, (float)scale);
        matrixStack.m_85845_(new Quaternion(pitch, yaw, 0.0f, true));
        matrixStack.m_85837_(-center.f_82479_, -center.f_82480_, -center.f_82481_);
        if (doShading) {
            Lighting.m_84931_();
        }
        MultiBufferSource.BufferSource renderTypeBuffer = RenderUtils.getMainBufferSource();
        for (BlockPos pos : capture.getBlockLocations()) {
            ElevatorPreviewRenderer.renderBlock(capture, pos, matrixStack, (MultiBufferSource)renderTypeBuffer);
        }
        renderTypeBuffer.m_109911_();
        RenderSystem.m_69482_();
        if (doShading) {
            Lighting.m_84930_();
        }
        RenderUtils.renderBox((PoseStack)matrixStack, (AABB)cabinBox, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        if (previewBox != null) {
            RenderUtils.renderBox((PoseStack)matrixStack, (AABB)previewBox, (float)0.0f, (float)0.7f, (float)0.0f, (float)0.8f);
        }
        RenderSystem.m_157191_().m_85849_();
        RenderSystem.m_157182_();
    }

    private static void renderBlock(WorldBlockCapture capture, BlockPos pos, PoseStack matrixStack, MultiBufferSource renderTypeBuffer) {
        BlockEntity blockEntity;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        BlockState state = capture.getBlockState(pos);
        if (state.m_60734_() != Blocks.f_50016_) {
            BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
            EmptyModelData modelData = EmptyModelData.INSTANCE;
            RenderType renderType = ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)true);
            ElevatorPreviewRenderer.renderModel(model, capture, state, pos, matrixStack, renderTypeBuffer.m_6299_(renderType), (IModelData)modelData);
        }
        if ((blockEntity = capture.getBlockEntity(pos)) != null) {
            ClientUtils.getMinecraft().m_167982_().m_112267_(blockEntity, ClientUtils.getPartialTicks(), matrixStack, renderTypeBuffer);
        }
        matrixStack.m_85849_();
    }

    private static void renderModel(BakedModel modelIn, WorldBlockCapture capture, BlockState state, BlockPos pos, PoseStack matrixStackIn, VertexConsumer bufferIn, IModelData modelData) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ElevatorPreviewRenderer.renderQuads(capture, state, pos, matrixStackIn, bufferIn, modelIn.getQuads(state, direction, random, modelData));
        }
        random.setSeed(42L);
        ElevatorPreviewRenderer.renderQuads(capture, state, pos, matrixStackIn, bufferIn, modelIn.getQuads(state, null, random, modelData));
    }

    private static void renderQuads(WorldBlockCapture capture, BlockState state, BlockPos pos, PoseStack matrixStackIn, VertexConsumer bufferIn, List<BakedQuad> quadsIn) {
        PoseStack.Pose matrix = matrixStackIn.m_85850_();
        for (BakedQuad bakedquad : quadsIn) {
            float red = 1.0f;
            float blue = 1.0f;
            float green = 1.0f;
            float alpha = 1.0f;
            if (bakedquad.m_111304_()) {
                int color = ClientUtils.getMinecraft().m_91298_().m_92577_(state, (BlockAndTintGetter)capture.getWorld(), pos, bakedquad.m_111305_());
                red = (float)(color >> 16 & 0xFF) / 255.0f;
                green = (float)(color >> 8 & 0xFF) / 255.0f;
                blue = (float)(color & 0xFF) / 255.0f;
            }
            bufferIn.putBulkData(matrix, bakedquad, red, green, blue, alpha, 0xF000F0, OverlayTexture.f_118083_, false);
        }
    }
}

